<?php
	
class plgSystemluckyorangeInstallerScript
{
	/**
	 * Called on installation
	 *
	 * @param   JAdapterInstance  $adapter  The object responsible for running this script
	 *
	 * @return  boolean  True on success
	 */
	public function install(JAdapterInstance $adapter) {
		$this->_enableLuckyOrangePlugin();
/*
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		$cols = array(
			'extension_id', 
			'title_key', 
			'description_key', 
			'action_key', 
			'language_extension', 
			'language_client_id', 
			'type', 
			'action_file', 
			'action', 
			'condition_file', 
			'condition_method', 
			'version_introduced', 
			'enabled'
		);
		$values = array(
			700,
			$db->quote('Title of Message Goes Here'), 
			$db->q("This is body text for the message. Cats are cute!"), 
			$db->q("Configure Lucky Orange"),
			$db->q("plg_system_luckyorange"),
			1,
			$db->q("action"), 
			$db->q("site://plugins/system/luckyorange/postinstall/actions.php"),
			$db->q("luckyorange_postinstall_action"), 
			$db->q("site://plugins/system/luckyorange/postinstall/actions.php"), 
			$db->q("luckyorange_postinstall_condition"), 
			$db->q("3.4.0"), 
			1
		);
		
		$query
			->insert($db->qn('#__postinstall_messages'))
			->columns($db->qn($cols))
			->values(implode(',', $values));
		
		$db->setQuery($query);
		$db->execute();
*/
	}
	 
	public function uninstall($parent) {
		
		$db = JFactory::getDbo();
		$query = $db->getQuery(true);
		
		$query
			->delete($db->qn('#__postinstall_messages'))
			->where($db->qn('language_extension') . ' = ' . $db->q('plg_system_luckyorange'));
		
		$db->setQuery($query);
		$db->execute();
	}
 
	/**
	 * Called on update
	 *
	 * @param   JAdapterInstance  $adapter  The object responsible for running this script
	 *
	 * @return  boolean  True on success
	 */
	// public function update(JAdapterInstance $adapter);
	
	
	/**
	 * Enables Lucky Orange via DB query
	 *
	 * @param   JAdapterInstance  $adapter  The object responsible for running this script
	 *
	 * @return  boolean  True on success
	 */
	private function _enableLuckyOrangePlugin() {
		// Enable plugin
		$db  = JFactory::getDbo();
		$query = $db->getQuery(true);
		$query->update('#__extensions');
		$query->set($db->quoteName('enabled') . ' = 1');
		$query->where($db->quoteName('element') . ' = ' . $db->quote('LuckyOrange'));
		$query->where($db->quoteName('type') . ' = ' . $db->quote('plugin'));
		$db->setQuery($query);
		$db->execute();
	}
	
	private function _getLuckyOrangeInstallMessage() {
		$app = JFactory::getApplication();
		$input = $app->input;
		$msg_tmpl = 'Thank you for %s the Lucky Orange plugin! To get started tracking your visitors, please click the Lucky Orange link above.';
		$action;
		
		switch ( $route ) {
			
			case 'install':
			case 'discover_install':
			default:
				$action = 'installing';
			break;
			
			case 'update':
				$action = 'updating';
			break;
		}
		
		$msg = sprintf($msg_tmpl, $action);
		
		if ( $route === 'install' || $route === 'update' || $route === 'discover_install' ) {
			$html = JResponse::getBody();
			$html = htmlentities($html);
			JResponse::setBody($msg . "\n\n\n\n" . $html);
		}
	}
	
	function _messages_table_name($db) {
		return $db->quoteName('#__postinstall_messages');
	}
	
}