<?php
include 'connection.php';

$selectSql = "SELECT * FROM bbqpo_vendors";
$fetch = mysqli_query($connect,$selectSql);

?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Orders</title>
    <link rel="stylesheet" href="assets/css/bootstrap.css">
    <link rel="stylesheet" href="assets/css/fontawesome.css">
    <link rel="stylesheet" href="assets/css/select2.min.css">
    <link rel="stylesheet" href="assets/css/dataTables.bootstrap4.min.css">
    <link rel="stylesheet" href="assets/css/main.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/fixedheader/3.2.2/css/fixedHeader.bootstrap4.min.css">
</head>
<body>
    <div class="container-fluid pr-5 pl-5 mt-5">
        <div class="row justify-content-center">
            <h2 class="d-inline-block mr-2 mb-0">Orders Table</h2>
            <form action="" method="POST" class="row">
                <div class="col-12 ml-5 mb-2">
                    <button type="button" class="btn btn-primary"  data-toggle="modal" data-target="#exampleModal">Add Order</button>
                    <button type="button" class="btn btn-dark ml-3 run_crons">Process Orders</button>
                </div>
            <div class='col-12 ml-5 mb-4 d-flex'>
                 <div class="col-md-2">
                    <div class="form-group">
                        <select id="fillter_type" name="fillter_type" class="form-control fillter_type" onchange="this.form.submit()" style="display:inline-block;background-color: black; color: silver">
                            <option value="">Select Type</option>
                            <option value="BBQ" <?= (isset($_POST['fillter_type']) && $_POST['fillter_type'] == "BBQ") ? "selected" : '' ?>>LJ</option>
                            <option value="ALT" <?= (isset($_POST['fillter_type']) && $_POST['fillter_type'] == "ALT") ? "selected" : '' ?>>ALT</option>
                            <option value="ECOM" <?= (isset($_POST['fillter_type']) && $_POST['fillter_type'] == "ECOM") ? "selected" : '' ?>>ECOM</option>
                            <option value="Other" <?= (isset($_POST['fillter_type']) && $_POST['fillter_type'] == "Other") ? "selected" : '' ?>>Other</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <select id="fillter_status" name="fillter_status" class="form-control fillter_status" onchange="this.form.submit()" style="display:inline-block;background-color: black; color: silver">
                            <option value="">Select Status</option>
                            <option value="Ordered"  <?= (isset($_POST['fillter_status']) && $_POST['fillter_status'] == "Ordered") ? "selected" : '' ?>>Ordered</option>
                            <option value="To Be Ordered"  <?= (isset($_POST['fillter_status']) && $_POST['fillter_status'] == "To Be Ordered") ? "selected" : '' ?>>To Be Ordered</option>
                            <option value="Awaiting Confirmation" <?= (isset($_POST['fillter_status']) && $_POST['fillter_status'] == "Awaiting Confirmation") ? "selected" : '' ?>>Awaiting Confirmation</option>
                            <option value="Waiting Date" <?= (isset($_POST['fillter_status']) && $_POST['fillter_status'] == "Waiting Date") ? "selected" : '' ?>>Waiting Date</option>
                        </select>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                        <select id="fillter_vendors" name="fillter_vendors" class="form-control fillter_vendors" onchange="this.form.submit()" style="display:inline-block;background-color: black; color: silver">
                            <option value="">Select Vendor</option>
                                <?php 
                                   
                                    while($vendors = mysqli_fetch_assoc($fetch)) {
                                ?>
                                        <option value="<?= $vendors['value'] ?>" <?= (isset($_POST['fillter_vendors']) && $_POST['fillter_vendors'] == $vendors['value']) ? "selected" : '' ?>><?= $vendors['name'] ?></option>
                                <?php
                                    }
                                ?>
                        </select>
                    </div>
                </div>
                <div class="col-md-2">
                    <div class="form-group">
                    </div>
                </div>
                <div class="col-md-3 d-flex justify-content-between">
                    <div class="form-check mt-2">
                      <input class="form-check-input" type="checkbox" value="1" id="delivered" name="delivered" onchange="this.form.submit()"  <?= (isset($_POST['delivered']) && $_POST['delivered'] == 1) ? "checked" : '' ?>>
                      <label class="form-check-label" for="delivered">
                        Delivered
                      </label>
                    </div>
                    <div class="form-check mt-2">
                      <input class="form-check-input" type="checkbox" value="1" id="shipped" name="shipped" onchange="this.form.submit()"  <?= (isset($_POST['shipped']) && $_POST['shipped'] == 1) ? "checked" : '' ?>>
                      <label class="form-check-label" for="shipped">
                        Shipped
                      </label>
                    </div>
                    <div class="form-check mt-2">
                      <input class="form-check-input" type="checkbox" value="1" id="archive" name="archive" onchange="this.form.submit()"  <?= (isset($_POST['archive']) && $_POST['archive'] == 1) ? "checked" : '' ?>>
                      <label class="form-check-label" for="archive">
                        Archive
                      </label>
                    </div>
                </div>
                </div>
                <div class="col-12 ml-5 d-flex flex-wrap">
                    <div class="form-group d-flex align-items-center col-3 mb-0">
                        <label class="mb-0 mx-2" style="white-space:nowrap;">Start Date</label>
                        <input type="date" name="startDate" id="startDate" class="form-control"  value="<?= (isset($_POST['startDate'])) ?  $_POST['startDate']  : '' ?>">
                    </div>
                    <div class="form-group d-flex align-items-center col-3 mb-0">
                        <label class="mb-0 mx-2" style="white-space: nowrap;">End Date</label>
                        <input type="date" name="endDate" id="endDate" class="form-control" value="<?= (isset($_POST['endDate'])) ?  $_POST['endDate']  : '' ?>">
                    </div>
                    <div class="form-group d-flex align-items-center col-3 mb-0">
                        <label class="mb-0 mx-2" style="white-space: nowrap;">Pickup Date</label>
                        <input type="date" class="form-control" id="pickup_date" name="pickup_date" value="<?= (isset($_POST['pickup_date'])) ?  $_POST['pickup_date']  : '' ?>">
                    </div>
                    <div class="col-3"></div>
                    <div class="form-group d-flex mt-3 align-items-center col-3 mb-0">
                        <label class="mb-0 mx-2" style="white-space:nowrap;">Start Ordered Date</label>
                        <input type="date" name="startDate_ordered" id="startDate_ordered" class="form-control"  value="<?= (isset($_POST['startDate_ordered'])) ?  $_POST['startDate_ordered']  : '' ?>">
                    </div>
                    <div class="form-group d-flex mt-3 align-items-center col-3 mb-0">
                        <label class="mb-0 mx-2" style="white-space: nowrap;">End Ordered Date</label>
                        <input type="date" name="endDate_ordered" id="endDate_ordered" class="form-control" value="<?= (isset($_POST['endDate_ordered'])) ?  $_POST['endDate_ordered']  : '' ?>">
                    </div>                
                    <div class="form-group d-flex mt-3 align-items-center col-3 mb-0">
                        <button class="btn btn-primary">Search <i class="fas fa-search"></i></button>
                        <a href="/bbqpelletsonline/orders/" class="btn btn-secondary ml-3">Reset</a>
                    </div>
                </div>
            </div>
            </form>
            <input type="hidden" class="type_of_prod" value="<?= (isset($_POST['fillter_type'])) ? $_POST['fillter_type'] : '' ?>">
            <input type="hidden" class="fillter_status" value="<?= (isset($_POST['fillter_status'])) ? $_POST['fillter_status'] : '' ?>">
            <input type="hidden" class="fillter_vendors" value="<?= (isset($_POST['fillter_vendors'])) ? $_POST['fillter_vendors'] : '' ?>">
            <input type="hidden" class="startDate" value="<?= (isset($_POST['startDate'])) ? $_POST['startDate'] : '' ?>">
            <input type="hidden" class="endDate" value="<?= (isset($_POST['endDate'])) ? $_POST['endDate'] : '' ?>">
            <input type="hidden" class="delivered" value="<?= (isset($_POST['delivered'])) ? 1: '' ?>">
            <input type="hidden" class="shipped" value="<?= (isset($_POST['shipped'])) ? 1: '' ?>">
            <input type="hidden" class="archive_flag" value="<?= (isset($_POST['archive'])) ? 1: '' ?>">
            <input type="hidden" class="searchURL" id="searchURL" value="<?= $_GET['search'] ?>">
            <div class='col-12 mt-3'>
                <!--<a href="https://new.bbqpelletsonline.com/shipping_easy/parcelshipments.php"> go to parcelshipments  </a>-->
                <div class="table-responsive">
                    <table id="new_orders" class='trace-table table table-bordered table-light'>
                        <thead>
                            <th></th>
                            <th>Ordered</th>
                            <th> <span data-toggle="tooltip" data-placement="top" title="Number of Days">#</span></th>
                            <th>First Name Last Name / Company Name</th>
                            <th>Tons</th>
                            <th>Vendor</th>
                            <!--<th>Shipped</th>-->
                            <th>Pickup <br>Date</th>
                            <th>Shipper</th>
                            <th>Type</th>
                            <th>Paid</th>
                            <th>Order <br>Status</th>
                            <th>Contents</th>
                            <th>Called<br>In</th>
                            <th>Archive</th>
                            <th>Vendor<br>Paid</th>
                            <th>Action</th>
                        </thead>
                    </table>
                </div>
            </div>
        </div>
    </div>


<!-- Send mail -->
<div class="modal fade" id="send_email">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Send Email</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="form-row">
            <div class="form-group col-6">
                <label for="add_type_shipments">From</label>
                <select class="form-control custom-select" id="send_from">
                    <option value="">Choose From email</option>
                    <option SELECTED value="Info+order@MushroomMediaOnline.com">Mushroom media online + order</option>                    
                </select>                
            </div>
            <div class="form-group col-6">
                <label for="send_to">To</label>
                <select class="form-control custom-select" id="send_to">
                    <option value="">Choose To email</option>
                    <!-- <option value="jasmineikhy@gmail.com">Jazz</option> -->
                    <option value="manowarmfg@gmail.com">Thor</option>
                    <option value="lancebrenda@netins.net">Diamond M</option>
                    <option value="riversidefeeds@gmail.com">Riverside Feeds</option>
                    <option value="lynne@janiesmill.com">Jani'e s Mill</option>
                    <option value="simpsonpelletizing@gmail.com">Simpson</option>
                    <option value="KMW@cercogroup.com">Cereal Byproducts</option>
                </select>                
            </div> 
            <div class="form-group col-12">
                <label for="send_subject">Subject</label>
                <input type="text" class="form-control" id="send_subject">
            </div> 
            <div class="form-group col-12">
                <label for="send_template">Template</label>
                <select class="form-control custom-select" id="send_template">
                    <option value="">Choose Template</option>
                    <option value="1">Diamond Order</option>
                    <option value="2">Simpson Order</option>
                    <option value="3">Riverside Order</option>
                    <option value="4">Man O War Order</option>
                    <option value="5">Janies Order</option>
                </select>
            </div>  
            <div class="form-group col-12">
                <label for="send_body">Body</label>
                <textarea class="form-control" name="send_body" id="send_body" rows="3"></textarea>
            </div>    
            <div class="form-group col-12">
                <label for="upload_file">Upload File</label>
                <div class="input-group mb-3">
                  <input type="file" class="form-control" id="upload_file">
                  <label class="input-group-text" for="upload_file">Upload</label>
                </div>
            </div>
            <input type="hidden" id="send_pickup">
            <input type="hidden" id="send_shipper">
            <input type="hidden" id="send_type">   
            <input type="hidden" id="send_name">    
            <input type="hidden" id="send_vendor">    
            <input type="hidden" id="send_tons">  
            <input type="hidden" id="send_company">
            <input type="hidden" id="send_lname">
            <input type="hidden" id="send_id">
            <input type="hidden" id="send_ship_date">
            <input type="hidden" id="send_ship_day">
            <input type="hidden" id="send_pickup_date">
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
        <button type="button" class="btn btn-primary btn-send-email">Send</button>
      </div>
    </div>
  </div>
</div> 

    <script src="assets/js/jquery-3.5.1.min.js"></script>
    <script src="assets/js/popper.min.js"></script>
    <script src="assets/js/bootstrap.js"></script>
    <script src="assets/js/fontawesome.js"></script>
    <script src="assets/js/sweetalert2.all.min.js"></script>
    <script src="assets/js/jquery.dataTables.min.js"></script>
    <script src="assets/js/select2.min.js"></script>
    <script src="assets/js/dataTables.bootstrap4.min.js"></script>
    <script src="assets/js/main.js"></script>
    <script src="https://cdn.datatables.net/fixedheader/3.2.2/js/dataTables.fixedHeader.min.js"></script>
    <script src="ckeditor/ckeditor.js"></script>
    <script>
        CKEDITOR.replace( 'send_body' );
    </script>
 <!-- Modal -->
  <div class="modal fade" id="update_quick" role="dialog">
    <div class="modal-dialog">
    
      <!-- Modal content-->
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title order_id_label">Order #<span></span></h4>
          <button type="button" class="close" data-dismiss="modal">&times;</button>
        </div>
        <div class="modal-body">
            <input type="hidden" name="id" id="order_id">
            <div class="col-md-12">
                <label>Tracking</label>
                <input type="text" class="form-control" name="edit_tracking" id="edit_tracking">
            </div>
            <div class="col-md-12">
                <label>Pickup number</label>
                <input type="text" class="form-control" name="edit_pickup_number" id="edit_pickup_number">
            </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
          <button type="button" class="btn btn-primary edit_quick">Edit</button>
        </div>
      </div>
      
    </div>
  </div>


  <!-- Modal -->
  <div class="modal fade" id="NewInvoice" role="dialog">
    <div class="modal-dialog modal-lg" style="width: 1200px;max-width:1200px;">
    
      <!-- Modal content-->
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title invoice-number">Invoice # <span></span></h4>
          <button type="button" class="close" data-dismiss="modal">&times;</button>
        </div>
        <div class="modal-body">
          <iframe style="width:100%;height:70vh" src=""></iframe>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
        </div>
      </div>
      
    </div>
  </div>
  
  <!-- Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">Add new order</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <form action="" method="POST" id="add-order">
            <div class="form-row">
                <div class="col-md-4">
                    <label>First Name</label>
                    <input type="text" class="form-control" name="firstname">
                </div>
                <div class="col-md-4">
                    <label>Last Name</label>
                    <input type="text" class="form-control" name="lastname">
                </div>
                <div class="col-md-4">
                    <label>Email</label>
                    <input type="email" class="form-control" name="email">
                </div>
            </div>  
            <div class="form-row mt-2">
                <div class="col-md-4">
                    <label>company</label>
                    <input type="text" class="form-control" name="company">
                </div>
                <div class="col-md-4">
                    <label>Tracking</label>
                    <input type="text" class="form-control" name="tracking">
                </div>
                <div class="col-md-4">
                    <label>FB invoice</label>
                    <input type="text" class="form-control" name="fbinvoiceid">
                </div>
            </div>  
            <div class="form-row mt-2">
                <div class="col-md-4">
                    <label>Shipper</label>
                    <select class="form-control custom-select" name="shipper">
                        <option value="Central">Central</option>
                        <option value="CTL2">CTL2</option>
                        <option value="Dohrn">Dohrn</option>
                        <option value="Magnum">Magnum</option>
                        <option value="Road Runner">Road Runner</option>
                        <option value="Speedee">Speedee</option>
                    </select>
                </div>
                <div class="col-md-4">
                    <label># of shipments</label>
                    <input type="number" class="form-control" name="of_shipments">
                </div>
                <div class="col-md-4">
                    <label>Ordered</label>
                    <input type="date" class="form-control" name="ordered">
                </div>
            </div>  
            <div class="form-row mt-2">
                <div class="col-md-4">
                    <label>Tons</label>
                    <input type="number" step="any" class="form-control" name="tons">
                </div>
                <div class="col-md-4">
                    <label>Type</label>
                    <select class="form-control custom-select" name="from_type">
                        <option value="BBQ">BBQ</option>
                        <option value="ALT">ALT</option>
                        <option value="ECOM">ECOM</option>
                        <option value="OTR">OTR</option>
                    </select>
                </div>
                <div class="col-md-4">
                    <label>Vendor</label>
                    <select class="form-control custom-select" name="vendor">
                                    <option value="">Select Vendor</option>
                            <?php 
                                $selectSql = "SELECT * FROM bbqpo_vendors";
                                $fetch = mysqli_query($connect,$selectSql);
                                while($vendors = mysqli_fetch_assoc($fetch)) {
                            ?>
                                    <option value="<?= $vendors['value'] ?>"><?= $vendors['name'] ?></option>
                            <?php
                                }
                            ?>
                    </select>
                </div>
            </div> 
            <div class="form-row mt-2">
                <div class="col-md-4">
                    <label>Delivery Type</label>
                    <select class="form-control custom-select" name="locationtype">
                        <option value=""></option>
                        <option value="Commercial">Commercial</option>
                        <option value="Residential">Residential</option>
                        <option value="Limited Access">Limited Access</option>                    
                    </select>
                </div>
                <div class="col-md-4">
                    <label>Unload Type</label>
                    <select class="form-control custom-select" name="hand_unload">
                        <option value=""></option>
                        <option value="Forklift/Dock">Forklift/Dock</option>
                        <option value="Liftgate">Liftgate</option>
                        <option value="Hand Unload">Hand Unload</option>                 
                    </select>
                </div>  
                <div class="col-md-4">
                    <label>Order Status</label>
                    <select class="form-control custom-select" name="shipping_status">
                        <option value=""></option>
                        <option value="LJ Queue">LJ Queue</option>
                        <option value="Awaiting Confirmation">Awaiting Confirmation</option>
                        <option value="To Be Ordered">To Be Ordered</option>
                        <option value="Ready to Ship">Ready to Ship</option>
                        <option value="Waiting Date">Waiting Date</option>
                    </select>
                </div>               
            </div>               
        </form>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
        <button type="button" class="btn btn-primary btn-add-order">Add</button>
      </div>
    </div>
  </div>
</div>
  
</body>
</html>
