<?php
include '../configuration.php';

function searchIPInFiles($directory, $ip) {
    $iterator = new RecursiveIteratorIterator(new RecursiveDirectoryIterator($directory));
    $filesContainingIP = [];

    foreach ($iterator as $file) {
        if ($file->isFile()) {
            $contents = file_get_contents($file->getPathname());
            if (strpos($contents, $ip) !== false) {
                $filesContainingIP[] = $file->getPathname();
                echo "Found in: " . $file->getPathname() . "\n";
            }
        }
    }

    print_r($filesContainingIP);

    return $filesContainingIP;
}

function createCSVFile($data) {
    header('Content-Type: text/csv');
    header('Content-Disposition: attachment; filename="files_containing_ip.csv"');
    
    $output = fopen('php://output', 'w');
    if ($output === false) {
        die("Error opening output stream\n");
    }

    echo "Writing data to CSV file\n";

    // Write the header
    fputcsv($output, ['File Path']);

    // Write the data
    foreach ($data as $filePath) {
        if (fputcsv($output, [$filePath]) === false) {
            echo "Error writing to CSV file at: $filePath\n";
        }
    }

    fclose($output);
    echo "CSV file created successfully.\n";
}

// Directory to search
$directoryToSearch = '/home/n89fdc5/public_html/api/bbqpelletsonline';
// IP address to search for

echo "Starting search in directory: $directoryToSearch\n";

// Check if the directory exists
if (!is_dir($directoryToSearch)) {
    die("Directory $directoryToSearch does not exist.\n");
}

$filesContainingIP = searchIPInFiles($directoryToSearch, $servernameDB);

echo "Found " . count($filesContainingIP) . " files containing the IP address $servernameDB.\n";

if (!empty($filesContainingIP)) {
    createCSVFile($filesContainingIP);
} else {
    echo "No files found containing the IP address.\n";
}

echo "Search complete.\n";
?>
